/**
* \file: Factory.cpp
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: CarPlay
*
* \author: J. Harder / ADIT/SW1 / jharder@de.adit-jv.com
*
* \copyright (c) 2014 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#include <stdarg.h>
#include <stdio.h>
#include <adit_logging.h>
#include "Factory.h"
#include "Common.h"

namespace adit { namespace carplay
{

Factory* Factory::singleton = nullptr;

Factory* Factory::Instance()
{
    if (singleton == nullptr)
        singleton = new Factory();

    return singleton;
}

void* Factory::Create(const std::string& name)
{
    // check for NULL
    if (name.empty())
        return nullptr;

    typename std::map<std::string, CreateImplementationFn>::iterator it;
    it = factoryMap.begin();

    #if 0
    // special case: on empty name return first creator (presumably the only one)
    if (it != factoryMap.end() && name.length() == 0)
    {
        return it->second();
    }
#endif

    it = factoryMap.find(name);
    if (it == factoryMap.end())
    {
        LOG_ERROR((dipo, "implementation %s not registered to factory", name.c_str()));
        return nullptr;
    }

    return it->second();
}

/*
 * Direct use of LOG_ERROR is not possible in Factory.h due to not available log macros in public
 * header.
 */
void Factory::logError(const char* msg, ...)
{
    char buf[1024];
    va_list args;
    va_start(args, msg);
    vsnprintf(buf, sizeof(buf), msg, args);
    va_end(args);

    LOG_ERROR((dipo, "%s", buf));
}

void Factory::logDebug(const char* msg, ...)
{
    char buf[1024];
    va_list args;
    va_start(args, msg);
    vsnprintf(buf, sizeof(buf), msg, args);
    va_end(args);

    LOGD_DEBUG((dipo, "%s", buf));
}

} } // namespace adit { namespace carplay
